clear all; clc; close all;

W = [35:10:45];

fc = 3.5e9;
Nr = 256;
lambda = physconst('lightspeed')/fc;

antElement = dipole( ...
    'Length', lambda/2, ...
    'Width',  lambda/100);

for w = 1:length(W)
    rxSpacing = W(w)/(Nr-1)*lambda;
    rxArray = linearArray( ...
        'Element',        antElement,...
        'NumElements',    Nr,...
        'ElementSpacing', rxSpacing);

    rxMCMtx = helperCalculateCouplingMatrix(rxArray, fc, [1 Nr]);

    save(['MC_W_' num2str(W(w)) '.mat'],'rxMCMtx');

    fprintf("Rep %d complete.\n", w); 
end


